//---------------------------------------------------------------------------
// Sample code for uM-FPU64 64-bit FLoating Point Coprocessor
// Micromega Corporation  www.micromegacorp.com
// Author: Cam Thompson
//
// @file    test_keypad.ino
// @target  Arduino
//
// This is a test routine for the uM-FPU64 keypad functions.
//
// @version
//  Mar 27, 2013
//  - original version for uM-FPU64
//---------------------------------------------------------------------------

#include <SPI.h>
#include <Fpu64.h>
#include <FpuSerial64.h>

//-------------------- uM-FPU Register Definitions -----------------------------
#define lastKeys    10                  // uM-FPU register

//-------------------- uM-FPU Function Definitions -----------------------------
#define getKey  0                       // uM-FPU user function
#define waitKey 1                       // uM-FPU user function
#define readKey 2                       // uM-FPU user function

//-------------------- setup ------------------------------------------------

void setup()
{
  Serial.begin(9600);                   // print program title
  Serial.println();
  Serial.println("\nTest keypad");
  
  SPI.begin();                          // initialize SPI and FPU
  Fpu.begin();

  if (Fpu.sync() == SYNC_CHAR)          // print FPU version
    FpuSerial.printVersionln();
  else
  {
    Serial.print("uM-FPU not detected");
    while(1) ;                          // stop if FPU not detected
  }
  
  //Fpu.write(F_BREAK);
}

//-------------------- loop -------------------------------------------------

void loop()
{
  Fpu.write(SELECTA, 0, FCALL, getKey);
  Fpu.wait();
  Serial.print("key code: ");
  FpuSerial.printLongln(0);
}

